﻿Imports System.IO.IsolatedStorage
Imports Petzold.Phone.Silverlight

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private settings As IsolatedStorageSettings = IsolatedStorageSettings.ApplicationSettings


    Public Sub New()
        InitializeComponent()
        AddHandler Application.Current.UnhandledException, AddressOf OnUnhandledException

        Dim text As String = Nothing

        If Not settings.TryGetValue(Of String)("text", text) Then
            text = "<Grid Background=""AliceBlue"">" & vbCr & "    " & vbCr & "</Grid>"
        End If

        txtbox.Text = text
    End Sub


    Protected Overrides Sub OnOrientationChanged(ByVal args As OrientationChangedEventArgs)
        uniformStack.Orientation =
            If(
                ((args.Orientation And PageOrientation.Portrait) = 0),
                System.Windows.Controls.Orientation.Horizontal,
                System.Windows.Controls.Orientation.Vertical)

        MyBase.OnOrientationChanged(args)
    End Sub


    Private Sub OnTextBoxTextChanged(ByVal sender As Object, ByVal args As TextChangedEventArgs)
        settings("text") = txtbox.Text
    End Sub


    Private Sub OnUnhandledException(ByVal sender As Object, ByVal args As ApplicationUnhandledExceptionEventArgs)
        statusText.Text = args.ExceptionObject.Message
        args.Handled = True
    End Sub


    Private Sub OnXamlCruncherTextBoxXamlResult(ByVal sender As Object, ByVal args As XamlCruncherEventArgs)
        If args.Error IsNot Nothing Then
            statusText.Text = args.Error
        Else
            container.Child = args.Element
            statusText.Text = "OK"
        End If
    End Sub
End Class

